import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/core.dart';
import 'package:photogram_admin_cp/import/bloc.dart';
import 'package:photogram_admin_cp/import/data.dart';

class AppProvider extends InheritedWidget {
  final AuthBloc auth;
  final ApiRepository apiRepo;
  final AppContentProvider appContentProvider;

  const AppProvider({
    Key? key,
    required app,
    required this.auth,
    required this.apiRepo,
    required this.appContentProvider,
  }) : super(key: key, child: app);

  static AppProvider of(BuildContext context) => context.findAncestorWidgetOfExactType<AppProvider>() as AppProvider;

  @override
  updateShouldNotify(oldWidget) => false;
}
